PrefabFiles = {
	"roncat",
	"roncatclover",
	"roncatolive",
	"roncatpottedclover",
	"roncatdoll",
	"roncatamulet",
	"roncathat",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/roncat.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/roncat.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/roncat.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/roncat.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/roncat_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/roncat_silho.xml" ),

    Asset( "IMAGE", "bigportraits/roncat.tex" ),
    Asset( "ATLAS", "bigportraits/roncat.xml" ),
	
	Asset( "IMAGE", "images/map_icons/roncat.tex" ),
	Asset( "ATLAS", "images/map_icons/roncat.xml" ),
	
	Asset( "IMAGE", "images/map_icons/roncatpottedclover.tex" ),
	Asset( "ATLAS", "images/map_icons/roncatpottedclover.xml" ),
	
	Asset( "IMAGE", "images/map_icons/roncatpottedclover_moonrock.tex" ),
	Asset( "ATLAS", "images/map_icons/roncatpottedclover_moonrock.xml" ),
	
	Asset( "IMAGE", "images/map_icons/roncatpottedclover_obsidian.tex" ),
	Asset( "ATLAS", "images/map_icons/roncatpottedclover_obsidian.xml" ),
	
    Asset( "ATLAS", "images/hud/clovertab.xml" ),
	
	Asset("SOUNDPACKAGE", "sound/roncat.fev"),
    Asset("SOUND", "sound/roncat.fsb"),

}


RemapSoundEvent( "dontstarve/characters/roncat/death_voice", "roncat/characters/roncat/death_voice" )
RemapSoundEvent( "dontstarve/characters/roncat/hurt", "roncat/characters/roncat/hurt" )
RemapSoundEvent( "dontstarve/characters/roncat/talk_LP", "roncat/characters/roncat/talk_LP" )
RemapSoundEvent( "dontstarve/characters/roncat/gasmask_talk", "roncat/characters/roncat/gasmask_talk" )
RemapSoundEvent( "dontstarve/characters/roncat/gasmask_hurt", "roncat/characters/roncat/gasmask_hurt" )

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local TUNING = GLOBAL.TUNING
local ACTIONS = GLOBAL.ACTIONS
local SpawnPrefab = GLOBAL.SpawnPrefab
local GetPlayer = GLOBAL.GetPlayer

-- Temporary solution without Shipwrecked
GLOBAL.CAPY_DLC = 2

-- The character select screen lines
STRINGS.CHARACTER_TITLES.roncat = "The Luck Seeker"
STRINGS.CHARACTER_NAMES.roncat = "Ron"
STRINGS.CHARACTER_DESCRIPTIONS.roncat = "*Good at finding clovers\n*Is jinxed when without lucky charms\n*Used to taking pain"
STRINGS.CHARACTER_QUOTES.roncat = "\"Where are you, pretty clovers?\""

-- Custom speech strings
STRINGS.CHARACTERS.RONCAT = require "speech_roncat"

-- The character's name as appears in-game 
STRINGS.NAMES.RONCAT = "Ron"

-- Custom recipe tag
STRINGS.TABS.CLOVER = "Luck"

-- Custom item descriptions
STRINGS.NAMES.RONCATCLOVER = "Clover"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATCLOVER = "A lucky clover! I better preserve it somehow."

STRINGS.NAMES.RONCATOLIVE = "Olives"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATOLIVE = "It looks so peaceful."

STRINGS.NAMES.RONCATOLIVE_COOKED = "Sliced Olives"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATOLIVE_COOKED = "Now all I need is a pizza."

STRINGS.NAMES.RONCATPOTTEDCLOVER = "Potted Clover"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATPOTTEDCLOVER = 
{
	GENERIC = "It's a potted clover.",
	NEAR = "It'll bring me good luck.",
	FAR = "It's no good all the way over there.",
}
STRINGS.RECIPE_DESC.RONCATPOTTEDCLOVER = "Plant your clover for lucky protection."

STRINGS.NAMES.RONCATPOTTEDCLOVER_MOONROCK = "Marble Clover"
STRINGS.RECIPE_DESC.RONCATPOTTEDCLOVER_MOONROCK = "Sturdier lucky protection."

STRINGS.NAMES.RONCATPOTTEDCLOVER_OBSIDIAN = "Obsidian Clover"
STRINGS.RECIPE_DESC.RONCATPOTTEDCLOVER_OBSIDIAN = "Makes volcanoes less scary. Slightly."

STRINGS.NAMES.RONCATDOLL = "Jinxed Doll"
STRINGS.NAMES.RONCATDOLL_KATIA = "Jinxed Katia"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATDOLL = "That's adorable."
STRINGS.RECIPE_DESC.RONCATDOLL = "Just like me. Everything hates it."
STRINGS.RECIPE_DESC.RONCATDOLL_KATIA = "Just like me. Everything hates it."

STRINGS.NAMES.RONCATAMULET = "Clover Amulet"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATAMULET = "It's like a clover magnet."
STRINGS.RECIPE_DESC.RONCATAMULET = "Brings good luck and more clovers."

STRINGS.NAMES.RONCATAMULET_GUARDIAN = "Guardian Amulet"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATAMULET_GUARDIAN = "I should get hurt. For my friends!"
STRINGS.RECIPE_DESC.RONCATAMULET_GUARDIAN = "Take damage for the team."

STRINGS.NAMES.RONCATAMULET_PEACE = "Peace Amulet"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATAMULET_PEACE = "I feel safer with this."
STRINGS.RECIPE_DESC.RONCATAMULET_PEACE = "No one has to get hurt!"

STRINGS.NAMES.RONCATAMULET_DISCORD = "Discord Amulet"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATAMULET_DISCORD = "This is madness!"
STRINGS.RECIPE_DESC.RONCATAMULET_DISCORD = "Why can't we get along?"

STRINGS.NAMES.RONCATHAT = "Leprechaun Hat"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RONCATHAT = "I have a sudden desire for wealth."
STRINGS.RECIPE_DESC.RONCATHAT = "A gold-lover's hat."

-- Custom minimap icons
AddMinimapAtlas("images/map_icons/roncat.xml")
AddMinimapAtlas("images/map_icons/roncatpottedclover.xml")
AddMinimapAtlas("images/map_icons/roncatpottedclover_moonrock.xml")
AddMinimapAtlas("images/map_icons/roncatpottedclover_obsidian.xml")

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "roncat")
AddModCharacter("roncat")

-- Decide to enable modifications
local initRoncat = function()
	if GetPlayer() and GetPlayer().prefab == "roncat" then
		return true
	elseif GLOBAL.SaveGameIndex:GetSlotCharacter(GLOBAL.Settings.save_slot) == "roncat" then
		return true
	else
		return false
	end
end

-- Quick check if DLC is enabled
local rogEnabled = function()
	return GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)
end

local swEnabled = function()
	return GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC)
end

local isVanilla = function()
	return not rogEnabled() and not swEnabled()
end
local function IsSpring()
	if GLOBAL.GetSeasonManager() and ((rogEnabled() and GLOBAL.GetSeasonManager():IsSpring()) or (swEnabled() and GLOBAL.GetSeasonManager():IsGreenSeason())) then
		return true
	else
		return false
	end
end

local function IsCloverSeason()
	if IsSpring() or (GLOBAL.GetSeasonManager() and GLOBAL.GetSeasonManager():IsRaining()) then
		return true
	else
		return false
	end
end

local function IsSummer()
	if GLOBAL.GetSeasonManager() and ((rogEnabled() and GLOBAL.GetSeasonManager():IsSummer()) or (swEnabled() and GLOBAL.GetSeasonManager():IsDrySeason())) then
		return true
	else
		return false
	end
end

local function SpringCombatMod(amt)
    if IsSpring() then
        return amt * TUNING.SPRING_COMBAT_MOD
    else
        return amt
    end
end

-- Check if lucky
local function IsLucky(inst)
	if inst.components.inventory then
		for k,v in pairs(inst.components.inventory.equipslots) do
			if v:HasTag("roncatluckywear") then
				return true
			end
		end
	end
	return false
end
-- Check if character has lucky charm
local function HasLuckyCharm(inst)
	if IsLucky(inst) then
		return true
	end
	if inst.components.inventory
	and inst.components.inventory:FindItem(function(item) return item:HasTag("roncatluckycharm") end ) ~= nil
	then
		return true
	end
	return false
end

-- Make this function available globally
GLOBAL.HasLuckyCharm = HasLuckyCharm

-- Check if character has unlucky charm
local function HasUnluckyCharm(inst)
	if inst.components.inventory
	and inst.components.inventory:FindItem(function(item) return item:HasTag("roncattargettaker") end ) ~= nil
	then
		return true
	elseif inst.components.container
	and inst.components.container:FindItem(function(item) return item:HasTag("roncattargettaker") end ) ~= nil
	then
		return true
	end
	return false
end

-- Check if jinxed
local IsJinxed = function(inst)
	return inst and (inst:HasTag("roncattargettaker") or ((inst:HasTag("roncatjinx") or HasUnluckyCharm(inst)) and not HasLuckyCharm(inst)))
end

-- Make this function available globally
GLOBAL.IsJinxed = IsJinxed

-- Quick way to find if jinx target taker is nearby
local FindTargetTaker = function(inst, dist)
	dist = dist or 15
	-- Find a jinx target taker
	local jinxtargettaker = GLOBAL.FindEntity(inst, dist, function(ent) 
		return ent.components.combat and ent:HasTag("roncattargettaker")
	end)
	
	return jinxtargettaker 
end

-- Make this function available globally
GLOBAL.FindTargetTaker = FindTargetTaker

-- Quick way to find if guardian is nearby
local FindGuardian = function(inst, dist)
	dist = dist or 15
	-- Find a guardian
	local guardian = GLOBAL.FindEntity(inst, dist, function(ent) 
		return ent:HasTag("roncatguardian")
	end)
	
	return guardian 
end

-- Quick way to find if jinx is nearby
local FindJinx = function(inst, dist, findtargettaker)
	if not inst:IsValid() then
		print("Warning: Non-valid inst for FindJinx.", inst)
	end
	dist = dist or 15
	if findtargettaker == nil then
		findtargettaker = true
	end
	
	if findtargettaker then
		-- Find a jinx target taker
		local jinxtargettaker = FindTargetTaker(inst,dist)
		
		-- Choose the target taker first
		if jinxtargettaker then 
			return jinxtargettaker 
		end
	end
	
	-- Find a normal jinx, since a target taker is not found
	local jinx = GLOBAL.FindEntity(inst, dist, function(ent) 
		return IsJinxed(ent)
	end)
	
	return jinx
end

-- Make this function available globally
GLOBAL.FindJinx = FindJinx

-- Check if within a lucky area
local FindLuckProtector = function(inst, dist)
	if not inst:IsValid() then
		print("Warning: Non-valid inst for FindLuckProtector.", inst)
	end
	dist = dist or 15
	-- Find a nearby protector
	return GLOBAL.FindEntity(inst, dist, function(ent) 
		return ent:HasTag("roncatluckprotector")
	end)
end

-- Make this function available globally
GLOBAL.FindLuckProtector = FindLuckProtector

-- Check if within a meteor repeller
local FindMeteorRepeller = function(inst, dist)
	dist = dist or 15
	-- Find a nearby protector
	return GLOBAL.FindEntity(inst, dist, function(ent) 
		return ent:HasTag("roncatmeteorrepeller")
	end)
end

local function IsCloverDay()
	local age = GLOBAL.GetClock().numcycles
	return age%7 == 6
end

-- Function to get random spawn from a table
local function GetRandomSpawn(spawntable)
	local totalchance = 0
    for m, n in ipairs(spawntable) do
        totalchance = totalchance + n.chance
    end
	local child = nil
    local childaggro = nil
	local childgotostate = nil
	
    local next_chance = math.random()*totalchance
	next_aggro = nil
	for m, n in ipairs(spawntable) do
		next_chance = next_chance - n.chance
		if next_chance <= 0 then
			child = n.item
			if n.aggro then childaggro = true else childaggro = false end
			if n.gotostate then childgotostate = n.gotostate end
			break
		end
	end
	return child, childaggro, childgotostate
end
---------------------------------------------------------
-- CLOVER SPAWNS
local cloverPick = function (inst)
	if not initRoncat() then
		return
	end
	local pickable = inst.components.pickable
	if pickable then
		local Pick_prev = pickable.Pick
		function pickable:Pick(picker)
			local chance = 0
			if IsCloverSeason() then
				-- Chances are higher to pick in spring or in rain
				if picker and picker:HasTag("roncatcloverfinder") then
					if picker and IsLucky(picker) then
						chance = 1/8
					else
						chance = 1/16
					end
				else
					if picker and IsLucky(picker) then
						chance = 1/16
					else
						chance = 1/32
					end
				end
			else
				-- Chances are lower outside of spring
				if picker and picker:HasTag("roncatcloverfinder") then
					if picker and IsLucky(picker) then
						chance = 1/12
					else
						chance = 1/24
					end
				else
					if picker and IsLucky(picker) then
						chance = 1/16
					else
						chance = 1/50
					end
				end
			end
			
			-- Every 7th day, chance is higher
			if (picker and picker:HasTag("roncatgoldfinder")) or (IsCloverDay() and picker and (IsLucky(picker) or picker:HasTag("roncatcloverfinder"))) then
				chance = chance * 4
			end
			
			if math.random() < chance then
				if picker and picker:HasTag("roncatgoldfinder") then
					pickable.product = "goldnugget"
				else
					pickable.product = "roncatclover"
				end
			end
			
			return Pick_prev(self, picker)
		end
	end
end

AddPrefabPostInit("flower", cloverPick)
AddPrefabPostInit("cave_fern", cloverPick)

-------------------------------------------------------
-- VOLCANO MANAGER
-- *Note to self* This is more effective than the meteor repel code for the DST version, in case I want to improve it in the future
local function RepelMeteor(inst, x, y, z, dist)
	local theta = math.random() * 2 * GLOBAL.PI
	local x, y, z = inst.Transform:GetWorldPosition()
	
	-- Place it outside of protected range
	x = x + (dist + (math.random() * dist)) * math.cos(theta)
	z = z - (dist + (math.random() * dist)) * math.sin(theta)
	
	return x, y, z
end
AddComponentPostInit("volcanomanager", function(VolcanoManager, inst)
	
	local SpawnFireRain_prev = VolcanoManager.SpawnFireRain
	function VolcanoManager:SpawnFireRain(x, y, z)
		-- Find fire rain repeller
		local pos = {x = x, y = y, z = z}
		local repeller = nil
		local radius = 17
		local repellers = TheSim:FindEntities(pos.x, pos.y, pos.z, 40, {"roncatfirerainrepeller"} )
	    for k,v in pairs(repellers) do
			-- Increase protection radius if multiple repellers are found
			if radius < 32 then
				radius = radius + 3
			end
	    end
		repellers = TheSim:FindEntities(pos.x, pos.y, pos.z, radius, {"roncatfirerainrepeller"} )
		local protected = false
	    for k,v in pairs(repellers) do
			 -- Find nearby repellers, prioritize closer repellers
			 --[[
	        if not repeller or (GLOBAL.distsq(pos, GLOBAL.Vector3(v.Transform:GetWorldPosition())) < GLOBAL.distsq(pos, GLOBAL.Vector3(repeller.Transform:GetWorldPosition()))) then
	            repeller = v
	        end
			]]
			if GLOBAL.distsq({x = x, y = y, z = z}, GLOBAL.Vector3(v.Transform:GetWorldPosition())) < (radius * radius) then
				local x2, y2, z2 = RepelMeteor(v, x, y, z, radius)
				x = x2
				y = y2
				z = z2
				protected = true
			end
	    end
		
		if not protected and math.random() < 0.75 then
			local jinx = nil
			if IsJinxed(GetPlayer()) then
				jinx = GetPlayer()
			end
			if jinx then
				-- Find a luck protector
				if FindLuckProtector(jinx,30) then
					return SpawnFireRain_prev(self, x, y, z)
				end
				
				local radius = 10				
				local theta = math.random() * 2 * GLOBAL.PI
				
				-- Place it at the player's location
				local x2, y2, z2 = jinx.Transform:GetWorldPosition()
				
				-- Place it near the player, rather than right on them
				x2 = x2 + (math.random() * radius) * math.cos(theta)
				z2 = z2 - (math.random() * radius) * math.sin(theta)
				
				x = x2
				y = y2
				z = z2
				
			end
		end
		return SpawnFireRain_prev(self, x, y, z)
	end	
	
end)

-------------------------------------------------------
-- SEWING
-- Make Ron doll sewable for health
AddComponentPostInit("sewing", function(Sewing, inst)
	if not initRoncat() then
		return
	end
	local DoSewing_prev = Sewing.DoSewing
	function Sewing:DoSewing(target, doer)
		if target.prefab == "roncatdoll" then
			if target.components.health then
				target.components.health:DoDelta(250,false,inst.prefab)
				if inst.components.finiteuses then
					inst.components.finiteuses:Use(1)
				end

				if Sewing.onsewn then
					Sewing.onsewn(inst, target, doer)
				end
				
				return true
			end
		elseif DoSewing_prev then
			return DoSewing_prev(self, target, doer)
		end
	end
end)
---------------------------------------------------------
-- SPIDER DENS/BEEHIVES
-- Modify the child spawner to be harsher for Ron.
AddComponentPostInit("childspawner", function(ChildSpawner, inst)
	if not initRoncat() then
		return
	end
	local SpawnChild_prev = ChildSpawner.SpawnChild
	function ChildSpawner:SpawnChild(target, prefab, radius)
		-- Random chance of occuring
		if math.random() <= 0.5 and not FindLuckProtector(inst) then
			local jinx = nil
			-- Check if target is already jinxed
			if target and IsJinxed(target) then
				jinx = target
			end
			-- Look for an jinx target if an jinxed target isn't already targeted
			if not jinx then
				jinx = FindJinx(inst)
			end
			if jinx then
				-- Set target to the jinx
				target = jinx
				
				-- Spawn emergency children instead of normal ones
				if (prefab == nil or ChildSpawner.childname == prefab) and ChildSpawner.roncatjinx_child ~= nil then
					prefab = ChildSpawner.roncatjinx_child
				end
			end
		end
		
		-- Perform the rest of the function as normal
		return SpawnChild_prev(self, target, prefab, radius)
	end	
end)

-- Function to set new jinx childs to child spawner
local setJinxChild = function(jinxchild)
	return function(inst)
		if not initRoncat() then
			return
		end
		if inst.components.childspawner then
			inst.components.childspawner.roncatjinx_child = jinxchild
		end
	end
end

AddPrefabPostInit("spiderden", setJinxChild("spider_warrior"))
AddPrefabPostInit("beehive", setJinxChild("killerbee"))
----------------------------------------------------------
-- EVERGREENS
local growth_stages =
{
    {name="short", leifscale=.7 },
    {name="normal", leifscale=1 },
    {name="tall", leifscale=1.25 },
}
local builds =
{
	normal = {
		leif="leif",
    },
	sparse = {
		leif="leif_sparse",
    },
}
local function find_leif_spawn_target(item) 
    if item.components.growable ~= nil and item.components.growable.stage <= 3 and not item:HasTag("birchnut") then
        return item:HasTag("tree") and not item:HasTag("stump") and not item:HasTag("burnt") and not item.noleif
    end
    return false
end

local function spawn_leif(target) 
    local leif = SpawnPrefab(builds[target.build].leif)
    local scale = target.leifscale
    local r,g,b,a = target.AnimState:GetMultColour()
    leif.AnimState:SetMultColour(r,g,b,a)
    
    --we should serialize this?
    leif.components.locomotor.walkspeed = leif.components.locomotor.walkspeed*scale
    leif.components.combat.defaultdamage = leif.components.combat.defaultdamage*scale
    leif.components.combat.hitrange = leif.components.combat.hitrange*scale
    leif.components.combat.attackrange = leif.components.combat.attackrange*scale
    local maxhealth = leif.components.health.maxhealth*scale
    local currenthealth = leif.components.health.currenthealth*scale
    leif.components.health:SetMaxHealth(maxhealth)
    leif.components.health:SetVal(currenthealth)
    
    leif.Transform:SetScale(scale,scale,scale) 
    if target.chopper then leif.components.combat:SuggestTarget(target.chopper) end
    leif.sg:GoToState("spawn")
    target:Remove()
    
    leif.Transform:SetPosition(target.Transform:GetWorldPosition())
end

local attemptLeifSpawn = function (inst)
	-- Check if protected from jinx
	if FindLuckProtector(inst) then
		return
	end
	local jinx = FindJinx(inst)
	if not jinx then
		return
	end
	-- Check if there's already a leif
	if GLOBAL.FindEntity(inst, 20, function(ent) return ent.prefab == "leif" end) then
		return
	end
	--
	local days_survived = GLOBAL.GetClock().numcycles
    if days_survived >=  TUNING.LEIF_MIN_DAY/2 then
		if math.random() <=  TUNING.LEIF_PERCENT_CHANCE then
			local numleifs = math.random(4)
			if days_survived > 30/2 then
				numleifs = math.random(5)
			elseif days_survived > 80/2 then
				numleifs = math.random(6)
			end
			
			for k = 1,numleifs do
				local target =  GLOBAL.FindEntity(inst,  TUNING.LEIF_MAXSPAWNDIST, find_leif_spawn_target)
				if target ~= nil then
					target.noleif = true
					target.leifscale = growth_stages[target.components.growable.stage].leifscale or 1
                    target.chopper = jinx
					target:DoTaskInTime(1 + math.random() * 3, spawn_leif)
				end
			end
		end
    end
end



-- Increase the chance of tree guards appearing by stacking on the current chance
local evergreenPostInit = function (inst)
	if not initRoncat() then
		return
	end
	inst:ListenForEvent("workfinished", attemptLeifSpawn)
end


AddPrefabPostInit("evergreen", evergreenPostInit)
AddPrefabPostInit("evergreen_normal", evergreenPostInit)
AddPrefabPostInit("evergreen_tall", evergreenPostInit)
AddPrefabPostInit("evergreen_short", evergreenPostInit)
AddPrefabPostInit("evergreen_sparse", evergreenPostInit)
AddPrefabPostInit("evergreen_sparse_normal", evergreenPostInit)
AddPrefabPostInit("evergreen_sparse_tall", evergreenPostInit)
AddPrefabPostInit("evergreen_sparse_short", evergreenPostInit)

----------------------------------------------------------
-- PALM TREES
-- (Note: Shares same growth stages as evergreen leifs)
local builds_palm =
{
	normal = {
		leif="treeguard",
	},
}
local function attemptTreeguardSpawn(inst, chopper)
	
	-- Check if protected from jinx
	if FindLuckProtector(inst) then
		return
	end
	local jinx = FindJinx(inst)
	if not jinx then
		return
	end
	-- Check if there's already a leif
	if GLOBAL.FindEntity(inst, 20, function(ent) return ent.prefab == "treeguard" end) then
		return
	end
	--

	local days_survived =  GLOBAL.GetClock().numcycles
	if days_survived >= TUNING.PALMTREEGUARD_MIN_DAY/2 then
		if math.random() <=  TUNING.PALMTREEGUARD_PERCENT_CHANCE then
			local numleifs = 3
			if days_survived > 30/2 then
				numleifs = math.random(3,4)
			elseif days_survived > 80/2 then
				numleifs = math.random(4,5)
			end

			for k = 1,numleifs do
				local target =  GLOBAL.FindEntity(inst, TUNING.PALMTREEGUARD_MAXSPAWNDIST,
					function(item)
						if item.components.growable and item.components.growable.stage <= 3 then
							return item:HasTag("tree") and (not item:HasTag("stump")) and (not item:HasTag("burnt")) and not item.noleif
						end
						return false
					end)

				if target  then
					target.noleif = true
					target.leifscale = growth_stages[target.components.growable.stage].leifscale or 1
					target:DoTaskInTime(1 + math.random()*3, function()
						if target and not target:HasTag("stump") and not target:HasTag("burnt") and
							target.components.growable and target.components.growable.stage <= 3 then
							local target = target
							if builds_palm[target.build] and builds_palm[target.build].leif then
								local leif = SpawnPrefab(builds_palm[target.build].leif)
								if leif then
									local scale = target.leifscale
									local r,g,b,a = target.AnimState:GetMultColour()
									leif.AnimState:SetMultColour(r,g,b,a)

									--we should serialize this?
									leif.components.locomotor.walkspeed = leif.components.locomotor.walkspeed*scale
									leif.components.combat.defaultdamage = leif.components.combat.defaultdamage*scale
									leif.components.health.maxhealth = leif.components.health.maxhealth*scale
									leif.components.health.currenthealth = leif.components.health.currenthealth*scale
									leif.components.combat.hitrange = leif.components.combat.hitrange*scale
									leif.components.combat.attackrange = leif.components.combat.attackrange*scale

									leif.Transform:SetScale(scale,scale,scale)
									leif.components.combat:SuggestTarget(jinx)
									leif.sg:GoToState("spawn")
									target:Remove()

									leif.Transform:SetPosition(target.Transform:GetWorldPosition())
								end
							end
						end
					end)
				end
			end
		end
	end
end

local palmtreePostInit = function (inst)
	if not initRoncat() then
		return
	end
	inst:ListenForEvent("workfinished", attemptTreeguardSpawn)
end

AddPrefabPostInit("palmtree", palmtreePostInit)
AddPrefabPostInit("palmtree_normal", palmtreePostInit)
AddPrefabPostInit("palmtree_tall", palmtreePostInit)
AddPrefabPostInit("palmtree_short", palmtreePostInit)
---------------------------------------------------------------
-- BIRCHNUT TREES
local attemptPoisonBirchnutSpawn = function (inst, data)
	-- Check if protected from jinx
	if FindLuckProtector(inst) then
		return
	end
	local jinx = FindJinx(inst)
	if not jinx then
		return
	end
	--
	local days_survived = GLOBAL.GetClock().numcycles
    if not inst.monster and inst.leaf_state ~= "barren" and inst.components.growable and inst.components.growable.stage == 3 and days_survived >= TUNING.DECID_MONSTER_MIN_DAY/2 then
    	--print("Chance of making a monster")
        local chance = TUNING.DECID_MONSTER_SPAWN_CHANCE_BASE
        local thresh_chance = { TUNING.DECID_MONSTER_SPAWN_CHANCE_LOW, TUNING.DECID_MONSTER_SPAWN_CHANCE_MED, TUNING.DECID_MONSTER_SPAWN_CHANCE_HIGH }
		for k,v in ipairs(TUNING.DECID_MONSTER_DAY_THRESHOLDS) do
            if days_survived >= v then
                chance = thresh_chance[k]
            else
                break
            end
        end
		
		-- Increase chance for Ron
		chance = chance * 1.5
		
		--print("Chance is ", chance)
        if math.random() <= chance then
        	--print("Trying to spawn monster")
            local pt = inst:GetPosition()
            local ents = GLOBAL.TheSim:FindEntities(pt.x, pt.y, pt.z, 30, {"birchnut"}, {"stump", "burnt", "monster", "FX", "NOCLICK", "DECOR", "INLIMBO"})
            local max_monsters_to_spawn = math.random(3,4)
            for k,v in pairs(ents) do
                if not v:HasTag("fire") and not v:HasTag("stump") and not v:HasTag("burnt") and v.leaf_state ~= "barren" and not v.monster and not v.monster_start_task and not v.monster_stop_task then
                    v.monster_start_task = v:DoTaskInTime(math.random(1,4), function(v) 
                        v:StartMonster() 
                        v.monster_start_task = nil
                    end) 
                    max_monsters_to_spawn = max_monsters_to_spawn - 1
                end
                if max_monsters_to_spawn <= 0 then break end
            end
        end
    end
end

-- Increase the chance of poison birchnut trees appearing by stacking on the current chance
local deciduousPostInit = function (inst)
	if not initRoncat() then
		return
	end
	inst:ListenForEvent("workfinished", attemptPoisonBirchnutSpawn)
end

AddPrefabPostInit("deciduoustree", deciduousPostInit)
AddPrefabPostInit("deciduoustree_normal", deciduousPostInit)
AddPrefabPostInit("deciduoustree_tall", deciduousPostInit)
AddPrefabPostInit("deciduoustree_short", deciduousPostInit)

-------------------------------------------------------------
-- GRAVE MOUND
local attemptMoundSpawn = function (inst)
	-- Attempt gold nugget spawn
	if GetPlayer():HasTag("roncatgoldfinder") then
		if not inst.components.lootdropper then
			inst:AddComponent("lootdropper")
		end
		local numtodrop = 0
		local maxtodrop = 4
		-- Figure out how many to drop
		while maxtodrop > 0 do
			maxtodrop = maxtodrop - 1
			if math.random() < 1/2 then
				numtodrop = numtodrop + 1
			end
		end
		-- Drop the decided number
		while numtodrop > 0 do
			numtodrop = numtodrop - 1
			inst.components.lootdropper:SpawnLootPrefab("goldnugget")
		end
		
	end
	
	-- Random chance
	if math.random() < 0.5 then
		
		-- Check if protected from jinx
		if FindLuckProtector(inst) then
			return
		end
		
		-- Check if Ron is the worker
		local jinx = FindJinx(inst)
		if not jinx then
			return
		end
		
		local child, childaggro, childgotostate = GetRandomSpawn({
			{chance = 2,  item = "spider", aggro = true},
			{chance = 0.5,  item = "spider_warrior", aggro = true},
			{chance = 0.25,  item = "spider_spitter", aggro = true},
			{chance = 0.25,  item = "spider_hider", aggro = true},
			{chance = 1,  item = "tentacle", aggro = true},
			{chance = 1,  item = "bat", aggro = true},
			{chance = 1,  item = "mosquito", aggro = true},
			{chance = 1,  item = "frog", aggro = true},
			{chance = 1,  item = "hound", aggro = true},
			{chance = 1,  item = "knight_nightmare", aggro = true},
			{chance = 0.25,  item = "bishop_nightmare", aggro = true},
			{chance = 0.1,  item = "rook_nightmare", aggro = true},
			{chance = 0.25,  item = "worm", aggro = true},
			{chance = 1,  item = "ghost"},
			{chance = 1,  item = "wetgoop"},
		})
		
		if inst:IsValid() then
			local item = SpawnPrefab(child)
			local spawnpos = GLOBAL.Vector3(inst.Transform:GetWorldPosition() )
			item.Transform:SetPosition(spawnpos:Get() )
			-- Aggro the target to Ron
			if childaggro and item.components.combat and jinx ~= nil then
				item.components.combat:SuggestTarget(jinx)
			end
		end
	end
		
end
local moundPostInit = function (inst)
	if not initRoncat() then
		return
	end
	inst:ListenForEvent("workfinished", attemptMoundSpawn)
end


AddPrefabPostInit("mound", moundPostInit)
-------------------------------------------------------------
-- CATCOON
-- Jinxed catcoon loot
local catcoonloot =
    {
		"spider",
		"spider",
		"spider",
		"frog",
		"frog",
		"frog",
		"killerbee",
		"killerbee",
		"killerbee",
		"mosquito",
		"mosquito",
		"mosquito",
		"roncatclover",
    }
	
-- Add chance of getting jinxed loot from catcoons
local catcoonPostInit = function (inst)
	if not initRoncat() then
		return
	end
	local PickRandomGift_orig = inst.PickRandomGift
	local PickRandomGift_plus = function(inst, tier)
		if math.random() <= 0.5 and FindJinx(inst) and not FindLuckProtector(inst) then
			return catcoonloot[math.random(#catcoonloot)]
		end
		return PickRandomGift_orig(inst, tier)
	end
	inst.PickRandomGift = PickRandomGift_plus
end
AddPrefabPostInit("catcoon", catcoonPostInit)

--------------------------------------------
-- TUMBLEWEED
local function GetTumbleweedLoot(inst)
	-- Tumbleweeds are RoG only.
    local possible_spawns =
    {
        {chance = 1,  item = "spider", aggro = true},
        {chance = 0.25,  item = "spider_warrior", aggro = true},
        {chance = 1,  item = "frog", aggro = true},
        {chance = 1,  item = "bee", aggro = true},
        {chance = 1,  item = "killerbee", aggro = true},
        {chance = 1,  item = "mosquito", aggro = true},
        {chance = 0.5,  item = "hound", aggro = true},
        {chance = 0.25,  item = "tallbird", aggro = true},
        {chance = 0.1,  item = "warg"},
        {chance = 0.5,  item = "perd"},
        {chance = 1,  item = "wetgoop"},
        {chance = 0.1,  item = "roncatclover"},
    }
    local totalchance = 0
    for m, n in ipairs(possible_spawns) do
        totalchance = totalchance + n.chance
    end

    local loot = {}
    local lootaggro = {}
    local next_loot = nil
    local next_aggro = nil
    local next_chance = nil
    local num_loots = 1--3
    while num_loots > 0 do
        next_chance = math.random()*totalchance
        next_loot = nil
        next_aggro = nil
        for m, n in ipairs(possible_spawns) do
            next_chance = next_chance - n.chance
            if next_chance <= 0 then
                next_loot = n.item
                if n.aggro then next_aggro = true end
                break
            end
        end
        if next_loot ~= nil then
            table.insert(loot, next_loot)
            if next_aggro then 
                table.insert(lootaggro, true)
            else
                table.insert(lootaggro, false)
            end
            num_loots = num_loots - 1
        end
    end
	return loot, lootaggro
end

local onTumbleweedPickup = function (inst, picker, specialtype)
	local item = nil
	local loot
	local lootaggro
	if specialtype == nil then
		loot, lootaggro = GetTumbleweedLoot(inst)
	elseif specialtype == "clover" then
		loot = {"roncatclover"}
		lootaggro = {false}
	elseif specialtype == "olive" then
		loot = {"roncatolive"}
		lootaggro = {false}
	elseif specialtype == "gold" then
		loot = {"goldnugget"}
		lootaggro = {false}
	else
		return
	end
	
    for i, v in ipairs(loot) do
        item = SpawnPrefab(v)
        item.Transform:SetPosition(inst.Transform:GetWorldPosition())
        if item.components.inventoryitem and item.components.inventoryitem.ondropfn then
            item.components.inventoryitem.ondropfn(item)
        end
        if lootaggro[i] and item.components.combat and picker ~= nil then
			item.components.combat:SuggestTarget(picker)
        end
    end
end

local tumbleweedPostInit = function (inst)
	if not initRoncat() then
		return
	end
	local pickable = inst.components.pickable
	if pickable then
		local onpickedfn_orig = pickable.onpickedfn
		local onpickedfn_plus = function(inst, picker, loot)
			if onpickedfn_orig then
				onpickedfn_orig(inst, picker, loot)
			end
			local cloverchance = 1/100
			if picker and IsLucky(picker) then
				cloverchance = 1/10
			end
			if IsCloverDay() then
				cloverchance = cloverchance * 2.5
			end
			if not FindLuckProtector(picker) and ((picker and IsJinxed(picker)) or (not HasLuckyCharm(picker) and FindJinx(picker) ~= nil) ) and math.random() <= 0.75 then
				-- Do jinxed pickup
				onTumbleweedPickup(inst,picker)
			elseif picker and not picker:HasTag("roncatgoldfinder") and math.random() <= cloverchance then
				-- Do lucky clover pickup
				onTumbleweedPickup(inst,picker,"clover")
			elseif picker and HasLuckyCharm(picker) and math.random() <= 1/25 then
				-- Do lucky olive pickup
				onTumbleweedPickup(inst,picker,"olive")
			elseif picker and picker:HasTag("roncatgoldfinder") and math.random() <= 1/5 then
				-- Do gold finder pickup
				onTumbleweedPickup(inst,picker,"gold")
			end
		end
		pickable.onpickedfn = onpickedfn_plus
	end
end

AddPrefabPostInit("tumbleweed", tumbleweedPostInit)

--------------------------------------
-- BERRY BUSHES
-- Add prefab post init for all bushes
local function AddBushPostInit(fn)
	AddPrefabPostInitAny( function(inst)
		if inst and inst:HasTag("bush") then fn(inst) end
	end)
end
-- List of prefabs to set berry anims
local berrybushes = {
	berrybush = true,
	berrybush_snake = true,
	berrybush2 = true,
	berrybush2_snake = true,
	coffeebush = true,
}
local function pickanim(inst)
	if inst.components.pickable then
		if inst.components.pickable:CanBePicked() then
			if berrybushes[inst.prefab] then
				local percent = 0
				if inst.components.pickable and inst.components.pickable.cycles_left then
					percent = inst.components.pickable.cycles_left / inst.components.pickable.max_cycles
				end
				if percent >= .9 then
					return "berriesmost"
				elseif percent >= .33 then
					return "berriesmore"
				else
					return "berries"
				end
			elseif inst.prefab == "limpetrock" then
				return "limpetmost"
			end
			-- Anything else would end up looking barren, which is why the shake animation is only used for these prefabs
		else
			if inst.components.pickable:IsBarren() then
				return "idle_dead"
			else
				return "idle"
			end
		end
	end

	return "idle"
end

local function spawnperd(inst, picker, child, childaggro, childgotostate)    
    if inst:IsValid() then
		local item = SpawnPrefab(child)
		local spawnpos = GLOBAL.Vector3(inst.Transform:GetWorldPosition() )
		spawnpos = spawnpos + GLOBAL.TheCamera:GetDownVec()
		item.Transform:SetPosition(spawnpos:Get() )
		if childgotostate ~= nil then
			item.sg:GoToState(childgotostate)
		end
		if item.components.homeseeker then
			item.components.homeseeker:SetHome(inst)
		end
		-- Aggro the target to Ron
		if childaggro and item.components.combat and picker ~= nil then
			item.components.combat:SuggestTarget(picker)
        end
		-- Shake
		if berrybushes[inst.prefab] or inst.prefab == "limpetrock" then
			if inst.components.pickable and inst.components.pickable:CanBePicked() then
				inst.AnimState:PlayAnimation("shake")
			else
				inst.AnimState:PlayAnimation("shake_empty")
			end
			inst.AnimState:PushAnimation(pickanim(inst), false)
		end
	end
end
local function attemptBushAmbush(inst, picker, child, childaggro, childgotostate)
	-- Spawn from many nearby berry bushes
	local pt = inst:GetPosition()
	local ents = GLOBAL.TheSim:FindEntities(pt.x, pt.y, pt.z, 15, {"bush"}, {"FX", "NOCLICK", "DECOR", "INLIMBO"})
	local max_monsters_to_spawn = math.random(4,10)
	for k,v in pairs(ents) do
		if not v:HasTag("fire") and not v:HasTag("withered") and math.random() < 0.5 then
			v:DoTaskInTime(1+math.random()*6, spawnperd, picker, child, childaggro, childgotostate)
			max_monsters_to_spawn = max_monsters_to_spawn - 1
		end
		if max_monsters_to_spawn <= 0 then break end
	end
end
local bushSpawns = 
{
	{chance = 4,  item = "spider", aggro = true},
	{chance = 0.25,  item = "spider_warrior", aggro = true},
	{chance = 1,  item = "bee", aggro = true},
	{chance = 1,  item = "killerbee", aggro = true},
	{chance = 1,  item = "mosquito", aggro = true},
	{chance = 1,  item = "hound", aggro = true},
	{chance = 0.1,  item = "tallbird", aggro = true},
	{chance = 0.25,  item = "perd", gotostate = "appear"},
}
local bushSpawns_cave = 
{
	{chance = 4,  item = "spider", aggro = true},
	{chance = 1,  item = "spider_warrior", aggro = true},
	{chance = 2,  item = "spider_hider", aggro = true},
	{chance = 1,  item = "spider_spitter", aggro = true},
	{chance = 1,  item = "mosquito", aggro = true},
	{chance = 4,  item = "bat", aggro = true},
	{chance = 1,  item = "spider_dropper", aggro = true},
	{chance = 0.5,  item = "slurtle", aggro = true},
}
local bushSpawns_shipwrecked = 
{
	{chance = 4,  item = "spider", aggro = true},
	{chance = 0.25,  item = "spider_warrior", aggro = true},
	{chance = 1,  item = "bee", aggro = true},
	{chance = 1,  item = "killerbee", aggro = true},
	{chance = 1,  item = "mosquito_poison", aggro = true},
	{chance = 1,  item = "hound", aggro = true},
	{chance = 0.1,  item = "tallbird", aggro = true},
	{chance = 4,  item = "snake", aggro = true},
	{chance = 1,  item = "snake_poison", aggro = true},
	{chance = 0.25,  item = "perd", gotostate = "appear"},
}
local bushSpawns_volcano = 
{
	{chance = 4,  item = "spider", aggro = true},
	{chance = 0.25,  item = "spider_warrior", aggro = true},
	{chance = 1,  item = "dragoon", aggro = true},
	{chance = 1,  item = "mosquito_poison", aggro = true},
	{chance = 1,  item = "hound", aggro = true},
	{chance = 0.1,  item = "tallbird", aggro = true},
	{chance = 4,  item = "snake", aggro = true},
	{chance = 1,  item = "snake_poison", aggro = true},
}
local onBushPick = function (inst, picker)
	local spawntable = bushSpawns
	if GLOBAL.GetWorld():HasTag("shipwrecked") then
		spawntable = bushSpawns_shipwrecked
	elseif GLOBAL.GetWorld():HasTag("cave") then
		spawntable = bushSpawns_cave
	elseif GLOBAL.GetWorld():HasTag("volcano") then
		spawntable = bushSpawns_volcano
	end
	local child, childaggro, childgotostate = GetRandomSpawn(spawntable)
	if not picker:HasTag("berrythief") then
		if math.random() < TUNING.PERD_SPAWNCHANCE*3 then
			-- Spawn from only this berry bush
			inst:DoTaskInTime(1+math.random()*1, spawnperd, picker, child, childaggro, childgotostate)
		elseif math.random() < 1/20 then
			attemptBushAmbush(inst, picker, child, childaggro, childgotostate)
		end
	end
end

AddBushPostInit(function(inst)
	if not initRoncat() then
		return
	end
	-- Attempt bush spawns when picking
	local pickable = inst.components.pickable
	if pickable then
		local onpickedfn_orig = pickable.onpickedfn
		local onpickedfn_plus = function(inst, picker, loot)
			if onpickedfn_orig then
				onpickedfn_orig(inst, picker, loot)
			end
			if not FindLuckProtector(inst) and ((picker and IsJinxed(picker)) or (not HasLuckyCharm(picker) and FindJinx(inst) ~= nil)) then
				onBushPick(inst,picker)
			end
		end
		pickable.onpickedfn = onpickedfn_plus
		
		-- Add chance to find olives
		local Pick_prev = pickable.Pick
		function pickable:Pick(picker)
			local chance = 0
			if IsSummer() then
				-- Chances are higher to pick in summer
				if picker and picker:HasTag("roncatcloverfinder") then
					if picker and HasLuckyCharm(picker) then
						chance = 1/10
					else
						chance = 1/100
					end
				else
					if picker and HasLuckyCharm(picker) then
						chance = 1/15
					else
						chance = 1/100
					end
				end
			else
				-- Chances are lower outside of summer
				if picker and picker:HasTag("roncatcloverfinder") then
					if picker and HasLuckyCharm(picker) then
						chance = 1/20
					else
						chance = 1/200
					end
				else
					if picker and HasLuckyCharm(picker) then
						chance = 1/50
					else
						chance = 1/500
					end
				end
			end
			
			local origproduct = pickable.product
			if math.random() < chance then
				pickable.product = "roncatolive"
			end
			
			-- Reset product
			
			inst:DoTaskInTime(5, function() pickable.product = origproduct end)
			
			return Pick_prev(self, picker)
		end
	end
	
	-- Attempt bush ambush when digging
	if inst.components.workable then
		local onwork_orig = inst.components.workable.onwork
		local onwork_plus = function(inst, worker, workleft)
			if workleft <= 0 and math.random() < 1/20 and not FindLuckProtector(inst) and ((worker and IsJinxed(worker)) or (not HasLuckyCharm(worker) and FindJinx(inst) ~= nil))then
				local spawntable = bushSpawns
				if GLOBAL.GetWorld():HasTag("cave") then
					spawntable = bushSpawns_cave
				end
				local child, childaggro, childgotostate = GetRandomSpawn(spawntable)
				attemptBushAmbush(inst, worker, child, childaggro, childgotostate)
			end
			if onwork_orig then
				onwork_orig(inst, worker, workleft)
			end
		end
		inst.components.workable.onwork = onwork_plus
	end
end)
--------------------------------------
-- CLOVERS AND OLIVES FROM TREES AND HACKABLES
local function attemptLuckyDrop(inst, worker)
-- Decide chance to find olives
	local olivechance = 1/20
	if IsSummer() then
		olivechance = 1/10
	end
	
	-- Decide chance to find clovers
	local cloverchance = 1/200
	if IsCloverSeason() then
		if worker and worker:HasTag("roncatcloverfinder") then
			if worker and IsLucky(worker) then
				cloverchance = 1/8
			else
				cloverchance = 1/16
			end
		else
			if worker and IsLucky(worker) then
				cloverchance = 1/12
			end
		end
	else
		if worker and worker:HasTag("roncatcloverfinder") then
			if worker and IsLucky(worker) then
				cloverchance = 1/12
			else
				cloverchance = 1/20
			end
		else
			if worker and IsLucky(worker) then
				cloverchance = 1/16
			end
		end
	end
	
	-- Every 7th day, chance is higher
	if IsCloverDay() and worker and (IsLucky(worker) or worker:HasTag("roncatcloverfinder")) then
		cloverchance = cloverchance * 2
	end
	
	-- Attempt olive spawn if worker has a lucky charm
	if math.random() < olivechance and worker and HasLuckyCharm(worker) then
		if not inst.components.lootdropper then
			inst:AddComponent("lootdropper")
		end
		inst.components.lootdropper:SpawnLootPrefab("roncatolive")
	elseif math.random() < cloverchance and worker and not worker:HasTag("roncatgoldfinder") then
	-- Attempt clover spawn
		if not inst.components.lootdropper then
			inst:AddComponent("lootdropper")
		end
		inst.components.lootdropper:SpawnLootPrefab("roncatclover")
	end
end

--------------------------------------
-- HACKABLES

local hackSpawns = 
{
	{chance = 2,  item = "spider", aggro = true},
	{chance = 0.25,  item = "spider_warrior", aggro = true},
	{chance = 0.5,  item = "mosquito_poison"},
	{chance = 1,  item = "hound", aggro = true},
	{chance = 0.1,  item = "tallbird", aggro = true},
	{chance = 8,  item = "snake", aggro = true},
	{chance = 4,  item = "snake_poison", aggro = true},
}
local function spawnhackjinx(inst, hacker, child, childaggro, childgotostate)    
    if inst:IsValid() then
		local item = SpawnPrefab(child)
		local spawnpos = GLOBAL.Vector3(inst.Transform:GetWorldPosition() )
		spawnpos = spawnpos + GLOBAL.TheCamera:GetDownVec()
		item.Transform:SetPosition(spawnpos:Get() )
		if childgotostate ~= nil then
			item.sg:GoToState(childgotostate)
		end
		if item.components.homeseeker then
			item.components.homeseeker:SetHome(inst)
		end
		-- Aggro the target to Ron
		if childaggro and item.components.combat and hacker ~= nil then
			item.components.combat:SuggestTarget(hacker)
        end
	end
end
local function attemptHackAmbush(inst, hacker, child, childaggro, childgotostate)
	print ("Hack ambush!!!")
	-- Spawn from many nearby hackables
	local pt = inst:GetPosition()
	local ents = GLOBAL.TheSim:FindEntities(pt.x, pt.y, pt.z, 15, nil, {"FX", "NOCLICK", "DECOR", "INLIMBO"})
	local max_monsters_to_spawn = math.random(4,8)
	for k,v in pairs(ents) do
		if v.components.hackable and v.components.hackable.canbehacked and not v:HasTag("fire") and not v:HasTag("withered") and math.random() < 0.5 then
			v:DoTaskInTime(0.5+math.random()*3, spawnhackjinx, hacker, child, childaggro, childgotostate)
			max_monsters_to_spawn = max_monsters_to_spawn - 1
		end
		if max_monsters_to_spawn <= 0 then break end
	end
end
local attemptHackSpawn = function (inst, data)
	-- Attempt gold nugget spawn
	if math.random() < 1/12 and data.hacker and data.hacker:HasTag("roncatgoldfinder") then
		if not inst.components.lootdropper then
			inst:AddComponent("lootdropper")
		end
		inst.components.lootdropper:SpawnLootPrefab("goldnugget")
	end
	
	-- Clover and olive chance
	attemptLuckyDrop(inst, worker)
	
	-- Attempt jinxed spawn
	if math.random() < 1/4 then
		-- Check if protected from jinx
		if FindLuckProtector(inst) then
			return
		end
		
		-- Check if Ron is the hacker
		if not data.hacker or not IsJinxed(data.hacker) then
			if HasLuckyCharm(data.hacker) then
				-- Hacker has a lucky charm
				return 
			end
			local jinx = FindJinx(inst)
			if jinx then
				-- Blame Ron
				data.hacker = jinx
			else
				-- Ron isn't nearby
				return
			end
		end
		
		local spawntable = hackSpawns
		local child, childaggro, childgotostate = GetRandomSpawn(spawntable)
		if math.random() < 1/4 then -- Chance on top of other chance
			-- Perform ambush
			attemptHackAmbush(inst, data.hacker, child, childaggro, childgotostate)
		else
			local item = SpawnPrefab(child)
			local spawnpos = GLOBAL.Vector3(inst.Transform:GetWorldPosition() )
			item.Transform:SetPosition(spawnpos:Get() )
			-- Aggro the target to Ron
			if childaggro and item.components.combat and data.hacker ~= nil then
				item.components.combat:SuggestTarget(data.hacker)
			end
		end
	end
end
-- Add prefab post init for all hackables
local function AddHackablePostInit(fn)
	AddPrefabPostInitAny( function(inst)
		if inst
		and inst.components.hackable
		then fn(inst) end
	end)
end
AddHackablePostInit(function(inst)
	if not initRoncat() then
		return
	end
	-- Check if prefab has a hackable component. 
	local onhackedfn_orig = inst.components.hackable.onhackedfn
	local onhackedfn_plus = function(inst, hacker, hacksleft)
		if hacksleft <= 0 then
			attemptHackSpawn(inst, {hacker = hacker})
		end
		if onhackedfn_orig then
			onhackedfn_orig(inst, hacker, hacksleft)
		end
	end
	inst.components.hackable.onhackedfn = onhackedfn_plus
	
	-- Attempt hackable ambush when digging
	if inst.components.workable then
		local onwork_orig = inst.components.workable.onwork
		local onwork_plus = function(inst, worker, workleft)
			if workleft <= 0 and math.random() < 1/8 and not FindLuckProtector(inst) and ((worker and IsJinxed(worker)) or (not HasLuckyCharm(worker) and FindJinx(inst) ~= nil))then
				local spawntable = hackSpawns
				local child, childaggro, childgotostate = GetRandomSpawn(spawntable)
				attemptHackAmbush(inst, worker, child, childaggro, childgotostate)
			end
			if onwork_orig then
				onwork_orig(inst, worker, workleft)
			end
		end
		inst.components.workable.onwork = onwork_plus
	end
end)

-------------------------------------------------------------
-- MISCELLANEOUS
local miscSpawns =
{
	{chance = 5,  item = "spider", aggro = true},
	{chance = 0.5,  item = "spider_warrior", aggro = true},
	{chance = 0.25,  item = "bat", aggro = true},
	{chance = 1,  item = "frog", aggro = true},
	{chance = 0.5,  item = "wetgoop"},
	{chance = 0.1,  item = "knight", aggro = true},
}
local miscSpawns_cave =
{
	{chance = 2,  item = "spider", aggro = true},
	{chance = 1,  item = "spider_warrior", aggro = true},
	{chance = 4,  item = "bat", aggro = true},
	{chance = 1,  item = "spider_spitter", aggro = true},
	{chance = 2,  item = "spider_hider", aggro = true},
	{chance = 0.5,  item = "wetgoop"},
	{chance = 0.25,  item = "knight_nightmare", aggro = true},
	{chance = 0.1,  item = "monkey", aggro = false},
}
local miscSpawns_shipwrecked =
{
	{chance = 5,  item = "spider", aggro = true},
	{chance = 0.5,  item = "spider_warrior", aggro = true},
	{chance = 5,  item = "snake", aggro = true},
	{chance = 1,  item = "snake_poison", aggro = true},
	{chance = 0.5,  item = "flup", aggro = true},
	{chance = 0.25,  item = "primeape", aggro = true},
	{chance = 0.5,  item = "wetgoop"},
}
local miscSpawns_aquatic =
{
	{chance = 5,  item = "stungray", aggro = true},
	{chance = 2,  item = "sharx", aggro = true},
	{chance = 0.1,  item = "knightboat", aggro = true},
	{chance = 0.25,  item = "swordfish", aggro = true},
	{chance = 0.5,  item = "wetgoop"},
}
local miscSpawns_volcano =
{
	{chance = 5,  item = "spider", aggro = true},
	{chance = 0.5,  item = "spider_warrior", aggro = true},
	{chance = 5,  item = "snake", aggro = true},
	{chance = 1,  item = "snake_poison", aggro = true},
	{chance = 0.5,  item = "flup", aggro = true},
	{chance = 0.25,  item = "primeape", aggro = true},
	{chance = 1,  item = "dragoon", aggro = true},
	{chance = 0.5,  item = "wetgoop"},
}
local attemptMiscSpawn = function (inst, data)
	-- Attempt gold nugget spawn
	if math.random() < 1/8 and data.worker and data.worker:HasTag("roncatgoldfinder") then
		if not inst.components.lootdropper then
			inst:AddComponent("lootdropper")
		end
		inst.components.lootdropper:SpawnLootPrefab("goldnugget")
	end
	
	-- Attempt jinxed spawn
	if math.random() < 1/5 then
		-- Check if protected from jinx
		if FindLuckProtector(inst) then
			return
		end
		
		-- Check if Ron is the worker
		if not data.worker or not IsJinxed(data.worker) then
			if HasLuckyCharm(data.worker) then
				-- Worker has a lucky charm
				return 
			end
			local jinx = FindJinx(inst)
			if jinx then
				-- Blame Ron
				data.worker = jinx
			else
				-- Ron isn't nearby
				return
			end
		end
		local spawntable = miscSpawns
		if GLOBAL.GetWorld():HasTag("shipwrecked") then
			if inst:GetIsOnWater() then
				spawntable = miscSpawns_aquatic
			else
				spawntable = miscSpawns_shipwrecked
			end
		elseif GLOBAL.GetWorld():HasTag("cave") then
			spawntable = miscSpawns_cave
		elseif GLOBAL.GetWorld():HasTag("volcano") then
			spawntable = miscSpawns_volcano
		end
		local child, childaggro, childgotostate = GetRandomSpawn(spawntable)
		
		local item = SpawnPrefab(child)
		local spawnpos = GLOBAL.Vector3(inst.Transform:GetWorldPosition() )
		item.Transform:SetPosition(spawnpos:Get() )
		-- Aggro the target to Ron
		if childaggro and item.components.combat and data.worker ~= nil then
			item.components.combat:SuggestTarget(data.worker)
		end
	end
end
-- Add prefab post init for all workables
local function AddWorkablePostInit(fn)
	AddPrefabPostInitAny( function(inst)
		if inst
		and inst.components.workable
		and not inst:HasTag("insect") -- Don't trigger when catching bugs
		and inst.prefab ~= "fireflies" -- Don't trigger when catching fireflies
		and inst.prefab ~= "mound" -- Mounds are already jinxed
		then fn(inst) end
	end)
end
AddWorkablePostInit(function(inst)
	if not initRoncat() then
		return
	end
	-- Check if prefab has a workable component. Only the server will have this
	if inst.components.workable then
		local onwork_orig = inst.components.workable.onwork
		local onwork_plus = function(inst, worker, workleft)
			if workleft <= 0 then
				attemptMiscSpawn(inst, {worker = worker})
			end
			if onwork_orig then
				onwork_orig(inst, worker, workleft)
			end
		end
		inst.components.workable.onwork = onwork_plus
	end
end)

---------------------------------------------------------
-- STUMPS
-- Add prefab post init for all trees
local function AddTreePostInit(fn)
	AddPrefabPostInitAny( function(inst)
		if inst
		and inst.components.workable
		and (inst:HasTag("tree")
		or inst.prefab == "mushtree_tall"
		or inst.prefab == "mushtree_medium"
		or inst.prefab == "mushtree_short")		
		then fn(inst) end
	end)
end
local stumpSpawns =
{
	{chance = 3,  item = "spider", aggro = true},
	{chance = 0.5,  item = "spider_warrior", aggro = true},
	{chance = 0.25,  item = "bat", aggro = true},
	{chance = 1,  item = "frog", aggro = true},
	{chance = 0.5,  item = "hound", aggro = true},
	{chance = 0.1,  item = "knight", aggro = true},
}
local stumpSpawns_cave =
{
	{chance = 4,  item = "spider", aggro = true},
	{chance = 1,  item = "spider_warrior", aggro = true},
	{chance = 4,  item = "bat", aggro = true},
	{chance = 1,  item = "frog", aggro = true},
	{chance = 0.5,  item = "worm", aggro = true},
	{chance = 0.5,  item = "spider_spitter", aggro = true},
	{chance = 1,  item = "spider_hider", aggro = true},
	{chance = 1,  item = "spider_dropper", aggro = true},
	{chance = 0.1,  item = "knight_nightmare", aggro = true},
	{chance = 0.1,  item = "bishop_nightmare", aggro = true},
}
local stumpSpawns_shipwrecked =
{
	{chance = 3,  item = "spider", aggro = true},
	{chance = 0.5,  item = "spider_warrior", aggro = true},
	{chance = 3,  item = "snake", aggro = true},
	{chance = 1,  item = "snake_poison", aggro = true},
	{chance = 1,  item = "flup", aggro = true},
	{chance = 0.5,  item = "hound", aggro = true},
}
local stumpSpawns_volcano =
{
	{chance = 3,  item = "spider", aggro = true},
	{chance = 0.5,  item = "spider_warrior", aggro = true},
	{chance = 3,  item = "snake", aggro = true},
	{chance = 1,  item = "snake_poison", aggro = true},
	{chance = 1,  item = "flup", aggro = true},
	{chance = 0.5,  item = "dragoon", aggro = true},
}
local function spawnfromstump(inst, worker, child, childaggro, childgotostate, digself)    
	local item = SpawnPrefab(child)
	local spawnpos = GLOBAL.Vector3(inst.Transform:GetWorldPosition() )
	spawnpos = spawnpos + GLOBAL.TheCamera:GetDownVec()
	item.Transform:SetPosition(spawnpos:Get() )
	if childgotostate ~= nil then
		item.sg:GoToState(childgotostate)
	end
	-- Aggro the target to Ron
	if childaggro and item.components.combat and worker ~= nil then
		item.components.combat:SuggestTarget(worker)
	end
	if digself and inst.components.workable then
        inst.SoundEmitter:PlaySound("dontstarve/wilson/dig")
		inst.components.workable:WorkedBy(inst, 1)
	end
end

local attemptStumpAmbush = function (inst, worker)
	-- Check if protected from jinx
	if FindLuckProtector(inst) then
		return
	end
	
	-- Check if Ron is the worker
	if not worker or not IsJinxed(worker) then
		if HasLuckyCharm(worker) then
			-- Worker has a lucky charm
			return 
		end
		local jinx = FindJinx(inst)
		if jinx then
			-- Blame Ron
			worker = jinx
		else
			-- Ron isn't nearby
			return
		end
	end
	
	local spawntable = stumpSpawns
	if GLOBAL.GetWorld():HasTag("shipwrecked") then
		spawntable = stumpSpawns_shipwrecked
	elseif GLOBAL.GetWorld():HasTag("cave") then
		spawntable = stumpSpawns_cave
	elseif GLOBAL.GetWorld():HasTag("volcano") then
		spawntable = stumpSpawns_volcano
	end
	local child, childaggro, childgotostate = GetRandomSpawn(spawntable)
	-- Spawn from current stump
	spawnfromstump(inst, worker, child, childaggro, childgotostate, false)
	
	-- Spawn from many nearby stumps
	local pt = inst:GetPosition()
	local ents = GLOBAL.TheSim:FindEntities(pt.x, pt.y, pt.z, 15, {"stump"}, {"FX", "NOCLICK", "DECOR", "INLIMBO"})
	local max_monsters_to_spawn = math.random(5,10)
	for k,v in pairs(ents) do
		if not v:HasTag("fire") and math.random() < 0.75 then
			v:DoTaskInTime(1+math.random()*4, spawnfromstump, worker, child, childaggro, childgotostate, true)
			max_monsters_to_spawn = max_monsters_to_spawn - 1
		end
		if max_monsters_to_spawn <= 0 then break end
	end
end
local function JinxStump(inst)
	if inst.components.workable and inst:HasTag("stump") then
		local onfinish_orig = inst.components.workable.onfinish
		local onfinish_plus = function(inst, worker)
			if not worker:HasTag("stump") then -- Don't trigger if stump digs itself during stump ambush event
				if math.random() < 1/20 then
					attemptStumpAmbush(inst, worker)
				else
					attemptMiscSpawn(inst, {worker = worker})
				end
			end
			if onfinish_orig then
				onfinish_orig(inst, worker)
			end
		end
		inst.components.workable.onfinish = onfinish_plus
	end
end

AddTreePostInit(function(inst)
	if not initRoncat() then
		return
	end
	-- Check if prefab has a workable component.
	if inst.components.workable then
		-- Check if tree is a stump when loading
		inst:DoTaskInTime(0.1, JinxStump)
		
		local onfinish_orig = inst.components.workable.onfinish
		local onfinish_plus = function(inst, worker)
			-- Jinx the stump after tree is chopped.
			inst:DoTaskInTime(0, JinxStump)
			
			-- Attempt stump ambush
			local ran = math.random()
			--print("Stump ambush chance:", ran)
			if ran < 1/20 then
				attemptStumpAmbush(inst, worker)
			end
			
			-- Clover and olive chance
			attemptLuckyDrop(inst, worker)
			
			-- Bonus log chance
			if math.random() < 1/5 and worker and IsLucky(worker) then
				if not inst.components.lootdropper then
					inst:AddComponent("lootdropper")
				end
				inst.components.lootdropper:SpawnLootPrefab("log")
			end
			
			if onfinish_orig then
				onfinish_orig(inst, worker)
			end
		end
		inst.components.workable.onfinish = onfinish_plus
	end
end)


-------------------------------------------------------------
-- HOUNDED 
-- Add varg chance to hound attack (RoG/SW only)
local function GetSpawnPoint(pt)
	if GetPlayer():HasTag("aquatic") then 
		return 
	end 
    local theta = math.random() * 2 * GLOBAL.PI
    local radius = 30

	local offset = GLOBAL.FindWalkableOffset(pt, theta, radius, 12, true)
	if offset then
		return pt+offset
	end
	if offset then
		local pos = pt+offset
		
		if not swEnabled() then
			-- RoG
			return pos
		end
		
		-- SW
		local ground = GLOBAL.GetWorld()
	    local tile = GLOBAL.GROUND.GRASS
	    if ground and ground.Map then
	        tile = self.inst:GetCurrentTileType(pos:Get())
	    end

	    local onWater = ground.Map:IsWater(tile)
	    if not onWater then 
	    	return pos
	    end 
	end
end

AddComponentPostInit("hounded", function(self, inst)
	if not initRoncat() or not(rogEnabled() or swEnabled()) or GLOBAL.GetWorld():HasTag("cave") then
		return
	end
	self.jinxcooldown = 0
	local OnUpdate_prev = self.OnUpdate
	function self:OnUpdate(dt)
		self.jinxcooldown = self.jinxcooldown - dt
		if self.jinxcooldown < dt and self.timetoattack < dt then
			
			-- Choose a random player
			local target = GetPlayer()
			
			-- Find a jinx near the target
			local jinx = FindJinx(target)
			
			-- Set target to jinx
			if jinx and not FindLuckProtector(jinx) then
				target = jinx
			end
			
			-- Is the victim a jinx?
			if math.random() > 0.5 and GLOBAL.GetClock().numcycles > 20 and IsJinxed(target) and not FindLuckProtector(target) then
				local pt = GLOBAL.Vector3(target.Transform:GetWorldPosition())
				local spawn_pt = GetSpawnPoint(pt)
				if spawn_pt then
					-- Make a varg
					local spawn = GLOBAL.SpawnPrefab("warg")
					if spawn then
						spawn.Physics:Teleport(spawn_pt:Get())
						spawn:FacePoint(pt)
						spawn.components.combat:SuggestTarget(target)
					end
				end
				
			end
			
			-- Reset cooldown, whether or not a warg was unleashed
			self.jinxcooldown = 60
		end
		return OnUpdate_prev(self, dt)
	end
end)
-----------------------------------------------------------------
-- COMBAT
local function ondeath(inst, data)
	if data and data.afflicter then
		if data.afflicter:HasTag("roncatgoldfinder") then
			local numtodrop = 0
			if inst:HasTag("epic") then
				-- Giants: 2-10
				numtodrop = 2 + (math.random()*8)
			elseif (inst:HasTag("monster") or inst:HasTag("hostile")) and not inst:HasTag("eyeplant") then
				-- Monsters (except eyeplant): 0-2
				if math.random() < 1/8 then
					numtodrop = numtodrop + 1
				end
				if math.random() < 1/8 then
					numtodrop = numtodrop + 1
				end
			else
				-- Other: 0-1
				if math.random() < 1/16 then
					numtodrop = 1
				end
			end
			-- Drop gold nuggets
			--print("Dropping", numtodrop, "gold nuggets")
			if not inst.components.lootdropper then
				inst:AddComponent("lootdropper")
			end
			while numtodrop > 0 do
				numtodrop = numtodrop - 1
				inst.components.lootdropper:SpawnLootPrefab("goldnugget")
			end
		end
	end
end
AddComponentPostInit("combat", function(Combat, inst)
	if not initRoncat() then
		return
	end
	-- Retarget function targets jinx before actual target
	local SuggestTarget_prev = Combat.SuggestTarget
	function Combat:SuggestTarget(target)
		if (target and not target:HasTag("roncatcalmer")) and not inst:HasTag("shadowcreature") and (inst:HasTag("monster") or inst:HasTag("frog")) then
			-- Look for a target taker first
			local jinxtargettaker = FindTargetTaker(target,SpringCombatMod(12))
			if jinxtargettaker then
				-- Suggest target taker as target instead.
				return SuggestTarget_prev(self, jinxtargettaker)
			end
			
			-- Check if suggested target is jinxed
			if IsJinxed(target) then
				-- Target is jinxed. Keep target.
				return SuggestTarget_prev(self, target)
			end
			
			-- Find a jinx
			local jinx = FindJinx(target,SpringCombatMod(15), false)
			-- If a player is targeted, jinx takes the target. Else, target if not around a luck protector.
			if jinx and (target:HasTag("player") or not FindLuckProtector(jinx)) then
				-- Suggest jinx as target instead.
				return SuggestTarget_prev(self, jinx)
			end
		end
		
		-- Check if target has a calmer
		if math.random() < 0.75 and (target and target:HasTag("roncatcalmer")) then
			-- Targeting is avoided because of luckiness
			--print("Your luckiness has spared you of being targeted.")
			return false
		else
			-- No jinx to target.
			return SuggestTarget_prev(self, target)
		end
	end
	
	
	local GetAttacked_prev = Combat.GetAttacked
	function Combat:GetAttacked(attacker,damage, ...)
		
		if isVanilla() and self.inst:HasTag("roncatjinx") then
			-- No damage absorption in vanilla so I have to add it here
			damage = damage*0.5
		end
		-- Reduce damage of attacker if calmer
		if attacker and attacker:HasTag("roncatcalmer") then
			damage = damage*0.5
		end
		
		-- Check if valid for protection
		if inst:HasTag("roncatguardian")
		or inst:HasTag("roncattargettaker")
		or not(inst:HasTag("companion")
			or inst:HasTag("player")
			or (inst.components.follower and inst.components.follower.leader and inst.components.follower.leader:HasTag("roncatguardian")))
		then
			-- Not valid. Attack normally
			return GetAttacked_prev(self, attacker, damage, ...)
		end
		local guardian = FindGuardian(inst)
		-- Get attacked normally if guardian is attacker
		if guardian == attacker then
			return GetAttacked_prev(self, attacker, damage, ...)
		end
		local absorbed_damage = 0
		if guardian and guardian.components.health and guardian.components.health:GetPercent() > 0.2 then
			-- Absorb damage if guardian with sufficient health is nearby
			absorbed_damage = damage * 0.8
			if guardian.components.combat then
				-- Guardian gets attacked by amulet
				guardian.components.combat:GetAttacked(guardian.guardianamulet or guardian, absorbed_damage * 0.6)
			end
		end
		
		local leftover_damage = damage - absorbed_damage

		return GetAttacked_prev(self, attacker, leftover_damage, ...)
	end
	-- Give gold finder a chance to get gold fighting this
	inst:ListenForEvent("death", ondeath)
end)

-- Function to modify targeting behavior
-- *Note to self* SpringCombatMod is not taken into account since this function makes things even more aggressive 
--	than in spring, and will remain that aggressive all year.
local makeTargetJinx = function(dist, moodfn)
	return function (prefab)
		if not initRoncat() then
			return
		end
		if prefab.components.combat then
			if not moodfn then
				moodfn = function(inst) return true end
			end
			local targetfn_orig = prefab.components.combat.targetfn
			local targetfn_new = function(inst)
				local target = nil
				-- First retarget normally
				if targetfn_orig then target = targetfn_orig(inst) end
				if moodfn(inst) then
					-- If no target found, target jinx
					if target == nil then
						target = GLOBAL.FindEntity(inst, dist, function(guy)
							return inst.components.combat:CanTarget(guy) and not guy:HasTag("roncatcalmer") and IsJinxed(guy) 
						end)
					end
				end
				return target
			end
			prefab.components.combat.targetfn = targetfn_new
		end
	end
end
 
AddPrefabPostInit("frog", makeTargetJinx(TUNING.FROG_TARGET_DIST*3))
AddPrefabPostInit("spider", makeTargetJinx(TUNING.SPIDER_TARGET_DIST*3))
AddPrefabPostInit("spider_warrior", makeTargetJinx(TUNING.SPIDER_TARGET_DIST*4))
AddPrefabPostInit("killerbee", makeTargetJinx(TUNING.BEE_TARGET_DIST*2))
if swEnabled() then
	AddPrefabPostInit("snake", makeTargetJinx(TUNING.SNAKE_TARGET_DIST*2))
	AddPrefabPostInit("snake_poison", makeTargetJinx(TUNING.SNAKE_TARGET_DIST*2))
end

--------------------------------------------
-- NAMING
-- Function to set new names as Ron
local setName = function(newname)
	return function(inst)
		if not initRoncat() then
			return
		end
		local displaynamefn_prev = inst.displaynamefn
		local displaynamefn_new = function(inst)
			if inst.growtime == nil and GetPlayer() and GetPlayer():HasTag("roncatnamer") then
				return newname
			end
			if displaynamefn_prev then
				return displaynamefn_prev(inst)
			end
		end
		inst.displaynamefn = displaynamefn_new
	end
end

AddPrefabPostInit("catcoonhat", setName("Squirrel Cap"))
STRINGS.NAMES.RONCATNAMED_CATCOON = "Squirrelcoon"
AddPrefabPostInit("catcoon", setName(STRINGS.NAMES.RONCATNAMED_CATCOON))
AddPrefabPostInit("coontail", setName("Squirrel Tail"))
AddPrefabPostInit("goldnugget", setName("Shiny Acorn"))
AddPrefabPostInit("redgem", setName("Red Acorn"))
AddPrefabPostInit("bluegem", setName("Blue Acorn"))
AddPrefabPostInit("purplegem", setName("Purple Acorn"))
AddPrefabPostInit("orangegem", setName("Orange Acorn"))
AddPrefabPostInit("greengem", setName("Green Acorn"))
AddPrefabPostInit("yellowgem", setName("Yellow Acorn"))
AddPrefabPostInit("pinecone", setName("Pine Nut"))
AddPrefabPostInit("jungletreeseed", setName("Jungle Nut"))
STRINGS.NAMES.RONCATNAMED_BEARGER = "Darlene"
AddPrefabPostInit("bearger", setName(STRINGS.NAMES.RONCATNAMED_BEARGER))

